<?php
class SoftwareController { private $db; private $game; const TYPE_GAME = 'game'; const TYPE_APP = 'app'; const TYPE_OS = 'os'; public function __construct($game) { $this->db = Database::getInstance(); $this->game = $game; $this->initializeSoftware(); } private function initializeSoftware() { $result = $this->db->query("SELECT COUNT(*) as count FROM software")->fetch(); if ($result['count'] == 0) { $software = [ [ 'name' => 'Epic Adventure III', 'type' => self::TYPE_GAME, 'difficulty' => 1, 'cost' => 500, 'size_gb' => 0.8, 'release_year' => 2000, 'popularity' => 80 ], [ 'name' => 'Space Traders 2', 'type' => self::TYPE_GAME, 'difficulty' => 2, 'cost' => 1000, 'size_gb' => 1.2, 'release_year' => 2002, 'popularity' => 90 ], [ 'name' => 'Crypto Tycoon', 'type' => self::TYPE_GAME, 'difficulty' => 3, 'cost' => 2000, 'size_gb' => 2.5, 'release_year' => 2004, 'popularity' => 95 ], [ 'name' => 'PhotoPro X', 'type' => self::TYPE_APP, 'difficulty' => 2, 'cost' => 1500, 'size_gb' => 0.5, 'release_year' => 2001, 'popularity' => 85 ], [ 'name' => 'VideoMaster 4', 'type' => self::TYPE_APP, 'difficulty' => 3, 'cost' => 2500, 'size_gb' => 1.8, 'release_year' => 2003, 'popularity' => 88 ], [ 'name' => 'CodeStudio IDE', 'type' => self::TYPE_APP, 'difficulty' => 4, 'cost' => 3000, 'size_gb' => 3.2, 'release_year' => 2005, 'popularity' => 92 ], [ 'name' => 'SecureOS 11', 'type' => self::TYPE_OS, 'difficulty' => 4, 'cost' => 4000, 'size_gb' => 4.5, 'release_year' => 2006, 'popularity' => 100 ], [ 'name' => 'DataOS Pro', 'type' => self::TYPE_OS, 'difficulty' => 5, 'cost' => 5000, 'size_gb' => 5.0, 'release_year' => 2007, 'popularity' => 98 ] ]; foreach ($software as $item) { $this->db->query( "INSERT INTO software (name, type, difficulty, cost, size_gb, release_year, popularity) VALUES (?, ?, ?, ?, ?, ?, ?)", [ $item['name'], $item['type'], $item['difficulty'], $item['cost'], $item['size_gb'], $item['release_year'], $item['popularity'] ] ); } } } public function getAvailableSoftware() { $currentYear = $this->game->getCurrentYear(); $result = $this->db->query( "SELECT * FROM software WHERE purchased = 0 AND release_year <= ? ORDER BY cost ASC", [$currentYear] )->fetchAll(); return array_map(function($item) { return [ 'id' => $item['id'], 'name' => $item['name'], 'type' => $item['type'], 'difficulty' => $item['difficulty'], 'cost' => $item['cost'], 'size_gb' => $item['size_gb'], 'release_year' => $item['release_year'], 'popularity' => $item['popularity'] ]; }, $result); } public function getPurchasedSoftware() { $result = $this->db->query( "SELECT * FROM software WHERE purchased = 1 AND cracked = 0 ORDER BY difficulty ASC" )->fetchAll(); return array_map(function($item) { return [ 'id' => $item['id'], 'name' => $item['name'], 'type' => $item['type'], 'difficulty' => $item['difficulty'], 'size_gb' => $item['size_gb'] ]; }, $result); } public function getCrackedSoftware() { $result = $this->db->query( "SELECT * FROM software WHERE cracked = 1 AND uploaded = 0 ORDER BY size_gb DESC" )->fetchAll(); return [ 'success' => true, 'software' => array_map(function($item) { return [ 'id' => $item['id'], 'name' => $item['name'], 'type' => $item['type'], 'size_gb' => $item['size_gb'] ]; }, $result) ]; } public function purchaseSoftware($id) { $software = $this->db->query( "SELECT * FROM software WHERE id = ? AND purchased = 0", [$id] )->fetch(); if (!$software) { return [ 'success' => false, 'message' => 'Software not found or already purchased' ]; } if ($software['release_year'] > $this->game->getCurrentYear()) { return [ 'success' => false, 'message' => 'This software is not released yet' ]; } if (!$this->game->spendCredits($software['cost'])) { return [ 'success' => false, 'message' => 'Not enough credits' ]; } $this->db->query( "UPDATE software SET purchased = 1 WHERE id = ?", [$id] ); return [ 'success' => true, 'message' => 'Successfully purchased ' . $software['name'], 'software' => $software ]; } public function crackSoftware($id) { $software = $this->db->query( "SELECT * FROM software WHERE id = ? AND purchased = 1 AND cracked = 0", [$id] )->fetch(); if (!$software) { return [ 'success' => false, 'message' => 'Software not found or already cracked' ]; } $this->db->query( "UPDATE software SET cracked = 1 WHERE id = ?", [$id] ); return [ 'success' => true, 'message' => 'Successfully cracked ' . $software['name'], 'software' => $software ]; } public function uploadSoftware($id) { $software = $this->db->query( "SELECT * FROM software WHERE id = ? AND cracked = 1 AND uploaded = 0", [$id] )->fetch(); if (!$software) { return [ 'success' => false, 'message' => 'Software not found or already uploaded' ]; } $internetSpeed = $this->game->getInternetSpeed(); $baseUploadTime = $software['size_gb'] <= 1 ? 60 : ($software['size_gb'] <= 5 ? 180 : 300); $actualUploadTime = ceil($baseUploadTime / $internetSpeed); return [ 'success' => true, 'message' => 'Starting upload of ' . $software['name'], 'software' => $software, 'upload_time' => $actualUploadTime ]; } public function completeUpload($id) { $software = $this->db->query( "SELECT * FROM software WHERE id = ? AND cracked = 1 AND uploaded = 0", [$id] )->fetch(); if (!$software) { return [ 'success' => false, 'message' => 'Software not found or already uploaded' ]; } $this->db->query( "UPDATE software SET uploaded = 1 WHERE id = ?", [$id] ); $baseVisitors = $software['popularity'] * 3; $this->game->addVisitors($baseVisitors); return [ 'success' => true, 'message' => 'Successfully uploaded ' . $software['name'], 'visitors_gained' => $baseVisitors ]; } public function getCrackingGame($id) { $software = $this->db->query( "SELECT * FROM software WHERE id = ? AND purchased = 1 AND cracked = 0", [$id] )->fetch(); if (!$software) { return [ 'success' => false, 'message' => 'Software not found or already cracked' ]; } return [ 'success' => true, 'software' => $software ]; } } 